#!/bin/bash

set -e  # Quitte en cas d'erreur

echo "Mise à jour des paquets..."
sudo apt update

echo "Installation de Python3, python3-venv, pip3 et ffmpeg si nécessaire..."
sudo apt install -y python3 python3-venv python3-pip ffmpeg python3-tk libmpv-devel gpsbabel

echo "Création et activation d'un environnement virtuel dans ./venv"
python3 -m venv venv
source venv/bin/activate

echo "Mise à jour de pip"
pip3 install --upgrade pip

if [ ! -f requirements.txt ]; then
  echo "Erreur : fichier requirements.txt non trouvé dans le dossier courant."
  echo "Veuillez placer votre fichier requirements.txt ici avant de lancer ce script."
  exit 1
fi

echo "Installation des dépendances Python depuis requirements.txt..."
pip install -r requirements.txt

echo "Installation terminée !"
echo "Pour lancer votre programme :"
echo "  source venv/bin/activate"
echo "  python3 main.py"

echo "Entrez deactivate pour quitter l'environnement virtuel"