# Copyright (c) 2025, benilerouge.ddns.net
# Licensed under the MIT License.


import subprocess

class FFmpegOptimizer:
    @staticmethod
    def get_hwaccel_args():
        """Retourne les arguments d'accélération matérielle"""
        try:
            result = subprocess.run(["ffmpeg", "-hide_banner", "-encoders"],
                                  capture_output=True, text=True)
            if "nvenc" in result.stdout.lower():
                return ["-hwaccel", "cuda", "-hwaccel_output_format", "cuda"]
            elif "vaapi" in result.stdout.lower():
                return ["-hwaccel", "vaapi", "-hwaccel_output_format", "vaapi"]
            return []
        except:
            return []

    @staticmethod
    def verify_cut_integrity(video_path, cut_points, buffer=1.5):
        """Vérifie l'intégrité autour des points de découpe"""
        for pos in cut_points:
            cmd = [
                "ffmpeg", "-v", "error",
                "-ss", str(max(0, pos - buffer)),
                "-i", video_path,
                "-t", str(buffer * 2),
                "-f", "null", "-"
            ]
            result = subprocess.run(cmd, capture_output=True, text=True)
            if result.stderr.strip():
                return False
        return True

    @staticmethod
    def check_keyframe_alignment(video_path, timestamp):
        """Vérifie l'alignement des keyframes"""
        cmd = [
            "ffprobe",
            "-select_streams", "v:0",
            "-show_frames",
            "-read_intervals", f"%{timestamp}%",
            "-show_entries", "frame=key_frame,pkt_pts_time",
            "-of", "csv",
            video_path
        ]
        result = subprocess.run(cmd, capture_output=True, text=True)
        return "1,{}".format(timestamp) in result.stdout
